;script Message Extensions for mIRC v6.16
;version 1.5a #20050805:2151#
;public msgext f8

/*
Contact Information:

Author: Ecronika
Email:  Ecronika@defcon-one-script.de
IRC:    #cyberscripters @ Quakenet
*/

; User functions
; --------------

alias msgext {
  ;syntax /msgext
  ;description Opens the Preferences Dialog.
  ;returns null

  if ($isid) return

  dialog $iif($dialog(dme.setup),-v,-m dme.setup) dme.setup
}
alias f8 {
  var %i
  scid -a var % $+ i = 1 $(|) while ($chan(%i)) $chr(123) window -g0 $ $+ v1 $(|) inc % $+ i $chr(125)
}

; Exported functions
; ------------------

alias _dme.version return 1.5a #20050805:2151#
alias _dme.get {
  if ($bg.strip($strip($1-,o)) !=== $strip($1-,o)) return $ifmatch
  return $1-
}
alias beatsf {
  var %beattime = $calc((((($ctime - $ctime($puttok($fulldate,00:00:00,4,32)))+$timezone+$daylight)+3600)/86400)*1000)
  return $+(@,$right($+(00,$round(%beattime,0)),3))
}

; Internal functions
; ------------------

alias -l _regfix { return $replacex($1-,.,\.,\,\\,|,\|,$chr(123),$+(\,$chr(123)),$&
    $chr(125),$+(\,$chr(125)),$chr(91),$+(\,$chr(91)),$chr(93),$+(\,$chr(93)))
}
alias -l _text {
  ; Thank to StruC for fixing the IPv6 Display Mismatch and reporting the Action Message Error

  var %r = /(?<= |^)(?= |$)/g, %p = $iif($numtok($gettok($address($nick,5),2,$asc(@)),58) < 2,2,9)
  !.echo -q $regsub($iif(ACTION * iswm $right($rawmsg,- $+ $pos($rawmsg,:,%p)),$right($left($v2,-1),-8),$v2),%r,,%r)
  return $_contentfilter($_urlhilight(%r))
}
alias _urlhilight {
  if (!$_set(urlhilight)) return $1-
  var %r = /(http://|ftp://|www\.|ftp\.)([^[:space:]]*)/g
  var %s = $replace($_set(UrlHilightformat),&1;,\1\2)
  !.echo -q $regsub($1-,%r,%s,%r)
  return %r
}
alias -l _ddcolor {
  var %r = /(?<=\x03\d\d,|\x03\d,|\x03)(\d)(?!\d)/g
  !.echo -q $regsub($1,%r,0\1,%r)
  return %r
}
alias -l _cnick {
  var %j $cnick(0),%i 0,%p $nick($2,$1).pnick
  while (%i < %j) {
    inc %i
    if ($cnick(%i).method == 2) continue
    if (($cnick(%i) != $null) && ($($v1,2) !iswm $1)) continue
    if ($2 ischan) {
      if (($cnick(%i).modes != $null) && (!$regex(%p,$+(^[,$_regfix($v1),]+.*$)))) continue
      if (($cnick(%i).anymode) && (!$cnick(%i).nomode) && (%p == $1)) continue
      if (($cnick(%i).nomode) && (!$cnick(%i).anymode) && (%p != $1)) continue
      ;The Idle-Setting seems to be crap since idle=0 when a new message appears
      ;I will have to think about that option again
      if (($cnick(%i).idle) && ($calc($nick($2,$1).idle / 60) < $v1)) continue
    }
    else return $_ddcolor($iif($cnick(%i).color != $color(normal),$+(,$v1),))
    return $_ddcolor($iif($cnick(%i).color != $color(normal),$+(,$v1),))
  }
  if ($2 !ischan) return 
}
alias -l _moptions return $gettok($readini($mircini,options,$1),$2,44)
alias -l _dqwindow return $_moptions(n0,22)
alias -l _showmode return $_moptions(n2,30)
alias -l _showactive return $_moptions(n4,5)
alias -l _set {
  if ($isid) return $hget(theme_hashtable,$1)
  else hadd -m theme_hashtable $1-
}
alias -l _addquery {
  ; ### Regex need a change
  var %r     = $+(\*.*,%theme_nick,.*\*)
  !.echo -q $regex($1-,%r (.*))

  var %t     = $regml(1)
  var %n     = %theme_nick
  var %theme = $_ddcolor($_set(OnTextQuery))
  var %m     = $replace(%theme,&1;,$+($_cnick(%n),%n,),&2;,%t)

  ; ### Timestamp Problems
  echo -cmti2 no %n %m
}
alias -l _eventlist return OnTextChan OnTextQuery OnTextPrivate OnActionChan OnActionQuery OnInputChan UrlHilightFormat
alias -l _chantext {
  var %t = $_ddcolor($_set($+(On,$event,Chan))),%m,%n,%p = $+(-,$iif($_checkignore($address($nick,5)) || $_checkignore(#),n),$iif($_hgh != off,l),cmbfti)
  if ($_showmode) %m = $left($remove($nick(#,$nick).pnick,$nick),1)

  %n = $+($_cnick($nick,#),%m,$iif($_dnc.marknick(0).nick,$ifmatch,$nick),)

  _spacer text #

  if ($_set(AlignText)) echo $+(%p,25) $iif($event == text,no,a) # $_alignnick(#,$replace($left(%t,$calc($pos(%t,&2;,1) -1)),&1;,%n)) $replace($right(%t,$+(-,$calc($pos(%t,&2;,1) -1))),&2;,$bg.strip($strip($_text,o)))
  else                  echo $+(%p,2) $iif($event == text,no,a) # $replace(%t,&1;,%n,&2;,$bg.strip($strip($_text,o)))
  haltdef
}
alias -l _alignnick return $+($str($+(,$chr(32)),$calc(25 $iif($1 ischan && $chan($1).stamp, - 1 - $len($strip($timestamp))) - $len($strip($2)))),$2)
alias -l _privtext {
  var %n     = $nick
  var %theme = $_ddcolor($_set($iif($event == text,OntextQuery,OnActionQuery)))
  var %m     = $replace(%theme,&1;,$+($_cnick(%n),%n,),&2;,$bg.strip($strip($_text,o)))
  var %c     = $iif($event == text,no,a)

  if ($query($nick)) echo -cmti2 %c %n %m
  else {

    var %theme = $_ddcolor($_set($iif($event == text,OnTextPrivate,OnActionPrivate)))
    var %m     = $replace(%theme,&1;,$+($_cnick(%n),%n,),&2;,$bg.strip($strip($_text,o)))

    if ($window(Message Window)) echo -cdmti2 %c %m
    elseif ($_dqwindow) { dqwindow show | echo -cdmti2 %c %m }
    elseif ($cid == $activecid) && (@* !iswm $active) && ($_showactive(query)) {
      echo -camti2 %c %m
    }
    else echo -csmti2 %c %m
  }
  haltdef
}
alias -l bg.strip {
  if ($_set(bg.strip)) {
    var %r = /([0-9]{1,2})(,[0-9]{1,2})/g
    !.echo -q $regsub($1-,%r,\1,%r)
    return %r
  }
  return $1-
}
alias -l _checkignore return $hfind(theme_hashtable,$1,1,W).data
alias -l _fillsetup {
  if (!$dialog(dme.setup)) return
  var %t $ticks,%i $1,%j $hfind(theme_hashtable,Ignore*,0,w)
  while (%i <= %j) {
    did -a dme.setup 8 $_set($+(Ignore,%i))
    if ($calc($ticks - %t) > 50) && ($calc($v1 / %i * (%j - %i)) > 50) {
      .timer -ho 1 0 _fillsetup $calc(%i +1)
      return
    }
    inc %i
  }
  did -e dme.setup 5
}
alias -l sinput {
  .timersi -oim 1 10 if ($isalias(sinput)) sinput
  var %s = $+(editbox,$cid)
  if ($hash($editbox($active),32) != $_set(%s)) {
    _set %s $v1
    _set $+(content,%s) $_textconvert
  }
}
alias -l _textconvert {
  var %r = /(?<= |^)(?= |$)/g
  !.echo -q $regsub($editbox($active),%r,,%r)
  return %r
}
alias -l _selecttheme {
  if ($1) did -c $dname 14 $1
  did -o $dname 102 1 $_set($gettok($_eventlist,$did($dname,14).sel,32))
}
alias -l _modeprefix {
  if ($2 !ischan) || (!$_showmode) return
  return $left($remove($nick($2,$1).pnick,$1),1)
}
alias -l _contentfilter {
  if (!$_set(contentfilter)) return $1-
  var %text
  tokenize 32 $1-
  while ($1 != $null) {
    if   ($_set($+(filter_,$1))) { %text = %text $ifmatch }
    else                         { %text = %text $1       }

    tokenize 32 $2-
  }
  return %text
}
alias -l _hgh {
  var %i = $+(_hgh,$iif($network,$network,$server),$chan)
  if ($isid) return $_set(%i)
  else _set %i $1
}

; Popups
; ------

menu menubar {
  MSG Extensions:msgext
}
menu channel {
  Highlight
  .$iif(!$_hgh,$style(1)) Default:_hgh
  .-
  .$iif($_hgh == on,$style(1)) On:_hgh on
  .$iif($_hgh == off,$style(1)) Off:_hgh off
}

; mIRC Events and Command Replaces
; --------------------------------

on *:start: {
  if (($version < 6.16) || ($bits != 32)) {
    echo $color(no) -s *** Error: defcon Message Extensions + On Text Theme requires mIRC 32 Bit v6.16 and above.
    unload -rs $nopath($script)
  }

  var %f = $+(",$scriptdir,msgext.hsh")

  if ( $hget(theme_hashtable)) hdel  -w theme_hashtable *
  if (!$hget(theme_hashtable)) hmake    theme_hashtable 5

  if ($isfile(%f)) hload theme_hashtable %f
  var %i 1
  while ($gettok($_eventlist,%i,32)) {
    if ($null == $_set($v1)) _set $gettok($_eventlist,%i,32) $gettok(<&1;> &2;<&1;> &2;*&1;* &2;* &1; &2;* &1; &2;<&1;> &2;02&1;,%i,1)
    inc %i
  }

  if ($null != $_set(timestampfmt))  .timestamp -f $v2

  _set File %f

  if ($timer(si) == $null) sinput
}

on ^*:text:*:#:_chantext
on ^*:text:*:?:_privtext

on ^*:action:*:#:_chantext
on ^*:action:*:?:_privtext

alias query {
  .query $1-
  if ($window(Message Window)) {
    var %theme = $_ddcolor($_set(OnTextPrivate))
    set -u0 %theme_nick $1
    filter -dk _addquery $replace(%theme,&1;,$+(*,$1,*),&2;,*)
  }
}
on *:unload: {
  echo $color(i) -es Unload Defcon Message Extensions v $+ $_dme.version
  if ($dialog(dme.setup)) {
    echo $color(i) -s Close Dialog
    dialog -x dme.setup
  }
  if ($hget(theme_hashtable)) {
    echo $color(i) -s Free existing hash table.
    hfree $v1
  }
  echo $color(i) -es Finished Unloading Defcon Message Extensions v $+ $_dme.version
}
alias msg {
  if ($1 ischan) || ($query($1)) {
    var %t = $_ddcolor($_set(oninputchan))
    var %n = $+($_cnick($me,$1),$_modeprefix($me,$1),$me,)
  }
  else {
    var %t = -> $_set(OnTextPrivate)
    var %n = $1
  }

  if ($1 ischan) && ($_set(AlignText)) {
    var %p = -cti25
    var %m = $_alignnick($1,$replace($left(%t,$calc($pos(%t,&2;,1) -1)),&1;,%n)) $replace($right(%t,$+(-,$calc($pos(%t,&2;,1) -1))),&2;,$_urlhilight($2-))
  }
  else {
    var %p = -cti2
    var %m = $replace(%t,&1;,%n,&2;,$_urlhilight($2-))
  }
  if ($1 ischan) || ($query($1)) %p = %p own $1
  elseif ($window(Message Window)) || ($_dqwindow) %p = $+(%p,d) own
  elseif ($cid == $activecid) && (@* !iswm $active) %p = $+(%p,a) own
  else %p = $+(%p,s) own

  if ($1 ischan) _spacer text $1

  echo %p %m

  .!msg $1 $2-
  haltdef
}
alias say msg $active $1-
on *:input:*: {
  var %c = $readini($mircini,n,text,commandchar),%t
  if (!$ctrlenter) {
    if ($+(%c,me) * iswm $1-) describe $active $right($_set($+(contenteditbox,$cid)),-4)
    if ($+(%c,describe) * iswm $1-) describe $right($_set($+(contenteditbox,$cid)),-10)
    if ($+(%c,msg) * iswm $1-) msg $right($_set($+(contenteditbox,$cid)),-5)
    if ($+(%c,say) * iswm $1-) msg $active $right($_set($+(contenteditbox,$cid)),-5)
    if ($left($1,1) == %c) return
  }
  var %t = $iif($inpaste,$1-,$_set($+(contenteditbox,$cid)))
  if ($_dnc.version) && ($chan) && ($_dnc.get(%t)) %t = $_dnc.get(%t)
  msg $$iif($active != Status Window,$active) %t
  haltdef
}
alias me describe $active $1-
alias ame {
  var %i = $chan(0)
  while (%i) {
    describe $chan(%i) $1-
    dec %i
  }
}
alias amsg {
  var %i = $chan(0)
  while (%i) {
    msg $chan(%i) $1-
    dec %i
  }
}
alias describe {
  var %t = $_ddcolor($_set(onactionquery))
  var %n = $+($iif($_showmode && $1 ischan,$left($remove($nick($1,$me).pnick,$me),1)),$+($_cnick($me),$me,))
  if ($_set(AlignText)) && ($1 ischan) echo -cti25 a $1 $_alignnick($1,$replace($left(%t,$calc($pos(%t,&2;,1) -1)),&1;,%n)) $replace($right(%t,$+(-,$calc($pos(%t,&2;,1) -1))),&2;,$2-)
  else echo -cti2 a $1 $replace(%t,&1;,%n,&2;,$_urlhilight($2-))
  .!describe $1-
  haltdef
}

; GUI
; ---

dialog -l dme.setup {
  title "Messages Extensions [/msgext]"
  size -1 -1 189 165
  option dbu
  tab "Theme", 12, 6 6 176 135
  tab "Highlight", 16
  tab "Filter", 22
  text "&Timestamp format:", 1, 18 88 46 8, tab 12
  edit "", 2, 69 86 103 10, tab 12 autohs limit 30
  check "&Strip background colors", 3, 18 99 69 8, tab 12
  text "&Prevent messages highliting the window switchbar icon by this Users:", 7, 12 26 170 8, tab 16
  list 8, 12 36 120 36, tab 16 size extsel
  button "&Add...", 9, 138 36 37 12, tab 16
  button "&Remove", 10, 138 52 37 12, tab 16 disable
  list 14, 12 25 51 51, tab 12 size
  text "", 15, 69 25 103 33, tab 12
  edit "", 102, 69 65 103 10, tab 12 autohs limit 100
  edit "", 103, 69 65 103 10, tab 12 hide autohs autovs multi return
  check "Align Channel Text", 13, 18 121 57 8, tab 12
  check "Highlight URLs in Messages", 17, 18 110 71 8, tab 12
  text "&Prevent Switchbar Highlight for this channel:", 18, 12 75 143 8, tab 16
  list 19, 12 86 120 36, tab 16 size
  button "&Add...", 20, 138 86 37 12, tab 16
  button "&Remove", 21, 138 101 37 12, tab 16 disable
  text "Version: 1.5a #20050905:2151#", 4, 6 151 80 8, disable
  button "&OK", 5, 106 147 37 12, disable ok
  button "&Cancel", 6, 146 147 37 12, cancel
  box "Options", 11, 12 79 164 56, tab 12
  text "This Feature will allow you to hide, mask or replace incoming words. You can use it as an swear filter or replace annoying colorfull LoUgHiNg OuT LoUd Replaces some users use with something else... i will hope you find that usefull if its done...", 23, 12 25 165 28, tab 22
  check "Enable Content Filter", 24, 12 54 63 8, tab 22
  list 25, 12 66 105 50, tab 22 size
  button "&Add...", 26, 122 67 32 12, tab 22
  button "&Remove", 27, 122 81 32 12, tab 22 disable
  link "Update", 28, 86 150 20 8
  check "Smart Timestamp (alpha)", 29, 101 99 70 8, tab 12
  check "Line Spacer (alpha)", 30, 101 110 70 8, tab 12 disable
}
dialog -l dme.add {
  title "Add User"
  size -1 -1 117 48
  option dbu
  text "&Address (nick!user@host):", 1, 6 6 65 9
  edit "", 2, 6 17 105 10, autohs limit 110

  button "&OK", 8, 44 31 32 12, ok default
  button "&Cancel", 9, 79 31 32 12, cancel

  edit "", 10, 0 0 0 0, result autohs
}
on *:dialog:dme.setup:sclick:26: {
  var %t = $input(Format: Word Replace,e,Add Filter))
  if (%t != $null) did -a $dname 25 $+($gettok(%t,1,32),$chr(9),$gettok(%t,2-,32))
}
on *:dialog:dme.setup:init:0: {
  dialog -t $dname Messages Extensions $+([,$readini($mircini,n,text,commandchar),msgext])
  var %t $ticks,%i 1,%j $hfind(theme_hashtable,Ignore*,0,w),%k 1,%l $hfind(theme_hashtable,ChanIgnore*,0,w),%e 1
  var %y 1,%z $hfind(theme_hashtable,filter_*,0,w)
  if ($_set(bg.strip))      { did -c $dname  3 }
  if ($_set(AlignText))     { did -c $dname 13 }
  if ($_set(urlhilight))    { did -c $dname 17 }
  if ($_set(contentfilter)) { did -c $dname 24 }
  if ($_set(smarttime))     { did -c $dname 29 }

  did -a $dname 2 $timestampfmt

  while ($gettok($_eventlist,%e,32)) {
    did -a $dname 103 $_set($v1) $+ $crlf
    inc %e
  }

  while (%k <= %l) {
    did -a $dname 19 $_set($+(ChanIgnore,%k))
    inc %k
  }
  didtok $dname 14 44 Channel Msg,Query Msg,Private Msg,Channel Action,Query Action,Own Channel Msg,Url Highlight Format
  _selecttheme 1
  _showhelptext
  while (%y <= %z) {
    did -a $dname 25 $+($right($hfind(theme_hashtable,filter_*,%y,w),-7),$chr(9),$_set($hfind(theme_hashtable,filter_*,%y,w)))
    inc %y
  }
  while (%i <= %j) {
    did -a $dname 8 $_set($+(Ignore,%i))
    if ($calc($ticks - %t) > 500) && ($calc($v1 / (%i +6) * (%j +6)) > 1000) {
      .timer -ho 1 0 _fillsetup $calc(%i +1)
      return
    }
    inc %i
  }
  did -e $dname 5
}
on *:dialog:dme.setup:sclick:12:_showhelptext
alias -l _showhelptext {
  if ($did(dme.setup,14).sel == 7) did -o dme.setup 15 1 You can use the following Tags to include Information. $+ $crlf $+ $crlf $+ &&1; - The URL
  else did -o dme.setup 15 1 You can use the following Tags to include Information. $+ $crlf $+ $crlf $+ &&1; - The Nickname $+ $crlf $+ &&2; - The Message Text
}
on *:dialog:dme.setup:sclick:14:{
  _selecttheme
  _showhelptext
}
on *:dialog:dme.setup:sclick:5: {
  did -o dme.setup 2 1 $_ddcolor($did(2).text)
  _set bg.strip $did(dme.setup,3).state
  _set AlignText $did(dme.setup,13).state
  _set urlhilight $did(dme.setup,17).state
  _set contentfilter $did(dme.setup,24).state
  _set smarttime $did(dme.setup,29).state
  _set timestampfmt $did(dme.setup,2)
  .timestamp -f $did(dme.setup,2)

  hdel -w theme_hashtable Ignore*
  hdel -w theme_hashtable ChanIgnore*
  hdel -w theme_hashtable filter_*
  var %i 1,%j $did(8).lines
  while (%i <= %j) {
    _set $+(Ignore,%i) $did(8,%i)
    inc %i
  }
  var %i 1,%j $did(19).lines
  while (%i <= %j) {
    _set $+(ChanIgnore,%i) $did(19,%i)
    inc %i
  }
  var %i 1,%j $did(25).lines
  while (%i <= %j) {
    _set $+(filter_,$gettok($did(25,%i),1,9)) $gettok($did(25,%i),2,9)
    inc %i
  }
  hsave -o theme_hashtable $_set(File)
}
on *:dialog:dme.setup:sclick:6: {
  var %i 1
  while ($gettok($_eventlist,%i,32)) {
    _set $v1 $did($dname,103,%i)
    inc %i
  }
}
on *:dialog:dme.setup:sclick:8,19,25:did $iif($did($did).sel,-e,-b) $dname $calc($did +2)
on *:dialog:dme.setup:sclick:9,20:did -a dme.setup $calc($did -1) $$dialog($+(dme.add,$iif($did == 20,chan)),dme.add,-4)
on *:dialog:dme.setup:sclick:10,21,27:{
  var %l = $calc($did -2)
  while ($did($dname,%l,0).sel) {
    did -d $dname %l $did($dname,%l,1).sel
  }
  did $iif($did(%l).sel,-e,-b) $dname $did
}
on *:dialog:dme.setup:edit:102:_set $gettok($_eventlist,$did(14).sel,32) $did(102)
on *:dialog:dme.add*:sclick:8:did -a $dname 10 $did(2)
on *:dialog:dme.addchan:init:0:did -o $dname 1 1 Channel (#channel):
on *:dialog:dme.setup:sclick:28: url -n $+(http://update.defcon-one-script.de/msgext.php?version=,$gettok($_dme.version,2,35))
alias echo {
  if (!$_set(smarttime)) { echo $1- | return }
  var %t = $3-, %p = $1, %w = $2, %we = $2, %c
  if (-*c* iswm %p) var %t = $4-, %w = $3, %we = $3, %cn = $2
  if ($1 isnum) var %p = $2, %w = $3, %we = $3, %c = $1, %t = $4-
  if (-*t* !iswm %p) { echo $1- | return }
  if (-*s* iswm %p) var %w = Status Window, %we, %t = $iif($1 isnum || -*c* iswm %p,$3-,$2-)
  elseif (-*a* iswm %p) var %w = $active, %we, %t = $iif($1 isnum || -*c* iswm %p,$3-,$2-)
  elseif ("Status == %w) var %w = Status Window, %we, %t = $gettok(%t,2-,32)
  echo %c $iif($replace($remove(%p,t),i2,i19) != -,$ifmatch) %cn %we $iif($strip($timestamp) == $strip($gettok($line(%w,$line(%w,0)),1,32)),$+(,$color(background).dd,$strip($timestamp),),$timestamp) %t
}
alias -l _spacer {
  return
  if ($group(#testpart) == off) return
  if ($1 != $hget(_spacer,$+($cid,$2))) {
    echo -t $2 
    hadd -m _spacer $+($cid,$2) $1
  }
}
#testpart on
on ^*:nick:{
  if ($gettok($readini($mircini,events,default),7,44)) return
  var %i $comchan($newnick,0)
  while (%i) {
    _spacer event $comchan($newnick,%i)
    if ($_set(AlignText)) echo -cti25 nick $comchan($newnick,%i) $_alignnick($comchan($newnick,%i),$+(*,$chr(32),$nick,$chr(32))) is now known as $newnick
    else echo -ct nick $comchan($newnick,%i) * $nick is now known as $newnick
    dec %i
  }
  haltdef
}
on ^*:quit:{
  var %i $comchan($nick,0)
  while (%i) {
    _spacer event $comchan($nick,%i)
    dec %i
  }
}
on ^*:join:#:{
  if ($nick == $me) return
  var %s = $gettok($readini($mircini,events,default),1,44),%p = -ct,%c

  if (%s == 2) return
  elseif (%s == 1) %p = %p $+ s
  else %c = #

  _spacer event #

  if ($_set(AlignText)) echo $+(%p,i25) join %c $_alignnick(#,$+(* $nick,$chr(32))) joined the channel $+([,$address,])
  else echo %p join %c * $nick joined the channel $+([,$address,])

  haltdef
}
on ^*:part:#:{
  if ($nick == $me) return

  var %s = $gettok($readini($mircini,events,default),2,44),%p = -ct,%c

  if (%s == 2) return
  elseif (%s == 1) %p = %p $+ s
  else %c = #

  _spacer event #

  if ($_set(AlignText)) echo $+(%p,i25) part %c $_alignnick(#,$+(* $nick,$chr(32))) parted the channel $+([,$address,])
  else echo %p part %c * $nick parted the channel $+([,$address,])

  haltdef
}


alias mtsimport {
  window -h @mtsimport
  loadbuf -tmts @mtsimport $1-
  var %i 1,%j = $numtok($mtsevents,32),%l,%n
  while (%i <= %j) {
    if ($getline($gettok($mtsevents,%i,32) *)) hadd -m theme_hashtable $gettok($msgextevents,%i,32) $mtsconvert($v1)
    inc %i
  }
  if ($getline(Timestampformat *)) .timestamp -f $mtsconvert($v1)
  %n = $+(n,$ini($mircini,colors,0))
  if ($getline(Colors *)) {
    var %t = $+(test,$ticks)
    writeini $mircini colors %n $+(%t,$chr(44),$v1)
    writeini $mircini palettes %n $rgbconvert
    color -l
    color -s %t
  }
  window -c @mtsimport
}
alias -l mtsconvert return $replacex($1-,<nick>,&1;,<text>,&2;,<cmode>,,<me>,&1;,<c1>,$bc(1),<c2>,$bc(2),<c3>,$bc(3),<c4>,$bc(4))
alias -l bc return $+(,$gettok($getline(Basecolors *),$1,44))
alias -l mtsevents return TextChan TextQuery ActionChan ActionQuery TextChanSelf
alias -l msgextevents return OnTextChan OnTextQuery OnActionChan OnActionQuery OnInputChan
alias -l rgbconvert {
  var %l = $fline(@mtsimport,rgbcolors *,1,0),%i = 2,%r
  while ($gettok($line(@mtsimport,%l),%i,32)) {
    %r = %r $+ $rgb($gettok($v1,1,44),$gettok($v1,2,44),$gettok($v1,3,44)) $+ ,
    inc %i
  }
  return $left(%r,-1)
}
alias -l getline {
  var %l = $fline(@mtsimport,$1,1,0)
  return $gettok($line(@mtsimport,%l),2-,32)
}
#testpart end
